<?php

class Element_Ultimate_AI_Google_Login_Register_Button extends \Elementor\Widget_Base
{
  public function get_name()
  {
    return 'element_ultimate_ai_google_login_register_button';
  }

  public function get_title()
  {
    return esc_html__('Google Login/Register button', ULTIMATE_AI_SLUG);
  }

  public function get_icon()
  {
    return 'eicon-lock-user';
  }

  public function get_categories()
  {
    return ['ultimate_ai_catetory'];
  }

  public function get_script_depends()
  {
    return ["element_ultimate_ai_google_login_register_btn"];
  }

  public function get_style_depends()
  {
    return [];
  }

  protected function register_controls()
  {
    $this->start_controls_section(
      'content_section',
      [
        'label' => esc_html__('Content', ULTIMATE_AI_SLUG),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'btn_title',
      [
        'label' => esc_html__('Title', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Default title', ULTIMATE_AI_SLUG),
        'placeholder' => esc_html__('Type your title here', ULTIMATE_AI_SLUG),
      ]
    );

    $this->add_control(
      'form_redirect_url',
      [
        'label' => esc_html__('Redirect url', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::URL,
        'options' => ['url'],
        'default' => [
          'url' => '',
        ],
        'label_block' => true,
      ]
    );

    $this->end_controls_section();



    $this->start_controls_section(
      'google_auth_button_section',
      [
        'label' => esc_html__('Button', ULTIMATE_AI_SLUG),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'google_auth_btn_typography',
        'selector' => '{{WRAPPER}} #ultimate-ai-root .uai_google_login_register_btn button',
        'label' => esc_html__('Typography', ULTIMATE_AI_SLUG),
      ]
    );
    $this->add_responsive_control(
      'google_auth_btn_color',
      [
        'label' => esc_html__('Text color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .uai_google_login_register_btn button' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'google_auth_btn_bgcolor',
      [
        'label' => esc_html__('Background color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .uai_google_login_register_btn button' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_responsive_control(
      'google_auth_button_border_radius',
      [
        'label' => esc_html__('Border radius', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .uai_google_login_register_btn button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'google_auth_button_icon_margin',
      [
        'label' => esc_html__('Icon margin', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .uai_google_login_register_btn button img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'Border',
        'selector' => '#ultimate-ai-root .uai_google_login_register_btn button',
      ]
    );

    $this->add_responsive_control(
      'google_auth_button_padding',
      [
        'label' => esc_html__('Padding', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .uai_google_login_register_btn button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $id = uniqid();
?>
    <div id="ultimate-ai-root">
      <div id="<?php echo $id; ?>"></div>
    </div>
    <script src="https://accounts.google.com/gsi/client" async defer></script>
    <script>
      window.addEventListener("load", () => {
        window.uai_redirect_form_url = "<?php echo $settings["form_redirect_url"]["url"] ?? "" ?>";
        window.Element_Ultimate_AI_Google_Login_Register_Button_RUN?.("<?php echo $id; ?>", "<?php echo $settings["btn_title"]; ?>");
      });
    </script>
  <?php
  }

  protected function content_template()
  {
  ?>
    <div id="ultimate-ai-root">
      <div class="uai_google_login_register_btn">
        <button>
          <img src="<?php echo UAI_ASSETS_URL_IMG . "svg_icons/google.svg" ?>" />
          {{{settings.btn_title}}}
        </button>
      </div>
    </div>
<?php
  }
}
